/******************************************************************************/
class OpenDoor : BaseEvent
{
public:
            OpenDoor();
   virtual ~OpenDoor();
   
   virtual void create(Object &obj); 
   virtual void AfterCreate(      );
   
private:

   virtual void CallTriggeredAction();
   virtual void StopTriggeredAction();
   
   UID m_DoorUID;
   SlidingDoor* m_Door;
   bool m_Open;
};
/******************************************************************************/
OpenDoor::OpenDoor() : BaseEvent(), m_Door(null)                          
{
   
}
OpenDoor::~OpenDoor()
{
   
}
/******************************************************************************/
void OpenDoor::create(Object &obj)
{
   // Getting the parameters from the object in the world
   if(Param *p = obj.findParam("DoorUID")) m_DoorUID = p.asID();
   if(Param *p = obj.findParam("Open"))    m_Open    = p.asBool(); // TODO_KORNEEL Would be nice to make this an enum
   
   super.create(obj); // Create the BaseEvent params too
}
/******************************************************************************/
void OpenDoor::AfterCreate()
{
   // Find the correct Door to work on. This has to be done here, because it's unreliable during create() (not all objects are loaded yet)
   REPA(slidingDoors)
      if(slidingDoors[i].id() == m_DoorUID)
            m_Door = &slidingDoors[i];
            
   DEBUG_ASSERT(m_Door, "SlidingDoor not found in scene"); 
}
/******************************************************************************/
// This method is called when the event was triggered, taking the delay into account
void OpenDoor::CallTriggeredAction()
{
   // (un)lock the door
   if(m_Door != null)
   {
      if(m_Open) m_Door->Open( );
      else       m_Door->Close();
   }
}

// This method is called when the duration of the event has been reached
void OpenDoor::StopTriggeredAction()
{
   // If m_Duration is not -1, the door can (un)lock again after some time
   // (un)lock the door
   if(m_Door != null)
   {
      if(m_Open) m_Door->Close();
      else       m_Door->Open( );
   }
}
/******************************************************************************/